program LAPLACE;
{--------------------------------------------------------------------}
{  Alg10'4.pas   Pascal program for implementing Algorithm 10.4      }
{                                                                    }
{  NUMERICAL METHODS: Pascal Programs, (c) John H. Mathews 1995      }
{  To accompany the text:                                            }
{  NUMERICAL METHODS for Math., Science & Engineering, 2nd Ed, 1992  }
{  Prentice Hall, Englewood Cliffs, New Jersey, 07632, U.S.A.        }
{  Prentice Hall, Inc.; USA, Canada, Mexico ISBN 0-13-624990-6       }
{  Prentice Hall, International Editions:   ISBN 0-13-625047-5       }
{  This free software is compliments of the author.                  }
{  E-mail address:       in%"mathews@fullerton.edu"                  }
{                                                                    }
{  Algorithm 10.4 (Dirichlet Method for Laplace's Equation).         }
{  Section   10.3, Elliptic Equations, Page 531                      }
{--------------------------------------------------------------------}

  uses
    crt;

  const
    Pi = 3.1415926535;
    GNmax = 630;
    MaxN = 26;
    MaxM = 101;
    FunMax = 9;

  type
    VECTOR = array[1..MaxN] of real;
    MATRIX = array[1..MaxN, 1..MaxM] of real;
    LETTER = string[8];
    States = (Changes, Done, Working);
    DoSome = (Go, Stop);
    LETTERS = string[200];

  var
    FunType, GNpts, Inum, M, Mend, Meth, N, Order, Sub: integer;
    A, B, C, C1, C2, H, Rnum, Y0: real;
    Ans: CHAR;
    U: MATRIX;
    State: States;
    DoMo: DoSome;
    Mess: LETTERS;

  function F1 (X: real): real;
  begin
    case FunType of
      1: 
        F1 := 20;
    end;
  end;

  function F2 (X: real): real;
  begin
    case FunType of
      1: 
        F2 := 180;
    end;
  end;

  function F3 (Y: real): real;
  begin
    case FunType of
      1: 
        F3 := 80;
    end;
  end;

  function F4 (Y: real): real;
  begin
    case FunType of
      1: 
        F4 := 0;
    end;
  end;

  procedure PRINTFUNCTION (FunType: integer);
  begin
    case FunType of
      1: 
        begin
          WRITELN;
          WRITELN('          The boundary functions are:');
          WRITELN;
          WRITELN('          u(x,0) = f1(x) = 20');
          WRITELN;
          WRITELN('          u(x,b) = f2(x) = 180');
          WRITELN;
          WRITELN('          u(0,y) = f3(x) = 80');
          WRITELN;
          WRITELN('          u(a,y) = f4(x) = 0');
        end;
    end;
  end;

  procedure Dirichlet ({FUNCTION F(x,t:real), G1(t:real), G2(t:real): real;}
                  A, B, H: real; N, M: integer; var U: MATRIX);
    var
      Count, I, J: integer;
      Ave, K, R, S, W, Relax, Tol: real;

    function F1i (I: integer): real;
    begin
      F1i := F1(H * (I - 1));
    end;

    function F2i (I: integer): real;
    begin
      F2i := F2(H * (I - 1));
    end;

    function F3i (I: integer): real;
    begin
      F3i := F3(H * (I - 1));
    end;

    function F4i (I: integer): real;
    begin
      F4i := F4(H * (I - 1));
    end;

  begin                                       {The main program Dirichlet}
    Ave := (A * (f1(0) + f2(0)) + B * (f3(0) + f4(0))) / (2 * A + 2 * B);
    for I := 2 to N - 1 do
      for J := 2 to M - 1 do
        U[I, J] := Ave;
    for J := 1 to M do
      begin
        U[1, J] := F3i(J);
        U[N, J] := F4i(J);
      end;
    for I := 1 to N do
      begin
        U[I, 1] := F1i(I);
        U[I, M] := F2i(I);
      end;
    U[1, 1] := (U[1, 2] + U[2, 1]) / 2;
    U[1, M] := (U[1, M - 1] + U[2, M]) / 2;
    U[N, 1] := (U[N - 1, 1] + U[N, 2]) / 2;
    U[N, M] := (U[N - 1, M] + U[N, M - 1]) / 2;
    W := 4 / (2 + SQRT(4 - SQR((COS(PI / (N - 1)) + COS(PI / (M - 1))))));
    Tol := 1;
    Count := 0;
    while (Tol > 0.001) and (Count <= 25) do
      begin
        Tol := 0;
        for J := 2 to M - 1 do
          begin
            for I := 2 to N - 1 do
              begin
                Relax := W * (U[I, J + 1] + U[I, J - 1] + U[I + 1, J] + U[I - 1, J] - 4.0 * U[I, J]) / 4.0;
                U[I, J] := U[I, J] + Relax;
                if Tol <= ABS(Relax) then
                  Tol := ABS(Relax);
              end;
          end;
        Count := Count + 1;
      end;
  end;

  procedure MESSAGE (var Meth: integer);
    var
      K: integer;
  begin
    CLRSCR;
    WRITELN('                      SOLUTION OF ELLIPTIC EQUATIONS');
    WRITELN;
    Meth := 1;
  end;

  procedure INPUT (var FunType, Meth: integer);
    var
      K: integer;
      Ans: LETTER;
  begin
    CLRSCR;
    WRITELN;
    WRITELN;
    WRITELN('          Solution of Laplace`s equation');
    WRITELN;
    WRITELN('                     u  (x,y)   +    u  (x,y)  =  0');
    WRITELN('                      xx              yy');
    WRITELN;
    WRITELN('          with the boundary values:');
    WRITELN;
    WRITELN('          u(x,0) = f1(x),  u(x,b) = f2(x)  for  0<=x<=A,');
    WRITELN;
    WRITELN('          u(0,y) = f3(x),  u(a,y) = f4(x)  for  0<=x<=B,');
    WRITELN;
    WRITELN('          A numerical approximation is computed over the rectangle');
    WRITELN;
    WRITELN('                             0<=x<=A.');
    WRITELN('                             0<=t<=B.');
    WRITELN;
    WRITELN('          You must supply the endpoints for the intervals.');
    WRITELN;
    WRITELN;
    WRITE('          Press the <ENTER> key. ');
    READLN(Ans);
    WRITELN;
    FunType := 1;
    Meth := 1;
  end;

  procedure EPOINTS (var A, B, H: real; var N, M: integer; var State: STATES);
    type
      STATUS = (Change, Enter, Done);
      LETTER = string[1];
    var
      I: integer;
      Valu: real;
      Resp: CHAR;
      Stat: STATUS;
  begin
    Stat := Enter;
    if State = Changes then
      Stat := Change;
    while (Stat = Enter) or (Stat = Change) do
      begin
        CLRSCR;
        WRITELN;
        WRITE('                 ');
        PRINTFUNCTION(FunType);
        WRITELN;
        WRITELN;
        if (Stat = Enter) then
          begin
            Mess := '     For the interval [0,A], ENTER  the endpoint   A = ';
            WRITE(Mess);
            READLN(A);
            WRITELN;
            Mess := '     For the interval [0,B], ENTER  the endpoint   B = ';
            WRITE(Mess);
            READLN(B);
            WRITELN;
            Mess := '                             ENTER the step size   H = ';
            WRITE(Mess);
            READLN(H);
            if H < 0 then
              H := ABS(H);
          end
        else
          begin
            WRITELN('     For the interval  [0,A],  the  endpoint  is   A =', A : 8 : 4);
            WRITELN;
            WRITELN;
            WRITELN('     For the interval  [0,B],  the  endpoint  is   B =', B : 8 : 4);
            WRITELN;
            WRITELN;
            WRITELN('                               The  step size is   H =', H : 8 : 4);
          end;
        WRITELN;
        WRITELN;
        WRITE('                         Want to make a change ?  <Y/N>  ');
        READLN(Resp);
        WRITELN;
        if (Resp = 'Y') or (Resp = 'y') then
          begin
            Stat := Change;
            CLRSCR;
            WRITELN;
            WRITE('                 ');
            PRINTFUNCTION(FunType);
            WRITELN;
            WRITELN('     [0,A] the current endpoint is A =', A : 8 : 4);
            Mess := '     ENTER  the NEW left  endpoint A =  ';
            WRITE(Mess);
            READLN(A);
            WRITELN;
            WRITELN('     [0,B] the current endpoint is B =', B : 8 : 4);
            Mess := '     ENTER  the NEW right endpoint B =  ';
            WRITE(Mess);
            READLN(B);
            WRITELN;
            WRITELN('     The  current  step  size   is  H =', H : 8 : 4);
            Mess := '     Now  ENTER the NEW  step size  H =  ';
            WRITE(Mess);
            READLN(H);
          end
        else
          Stat := Done;
      end;
    N := Round(A / H) + 1;
    M := Round(B / H) + 1;
  end;

  procedure RESULTS (FunType: integer; U: MATRIX; N, M: integer);
    var
      I, J: integer;
  begin
    CLRSCR;
    WRITELN;
    WRITELN;
    WRITE('      ');
    PRINTFUNCTION(FunType);
    WRITELN;
    WRITELN;
    WRITELN('          u(x ,y )   .....    u(x ,y )');
    WRITELN('             1  j                N  j');
    WRITELN('--------------------------------------------------------------------------------');
    WRITELN;
    for J := M downto 1 do
      begin
        for I := 1 to N do
          WRITE(U[I, J] : 8 : 3);
        WRITELN;
        if J mod 21 = 0 then
          begin
            WRITELN;
            WRITE('                  Press the <ENTER> key.  ');
            READLN(Ans);
            WRITELN;
            WRITELN;
          end;
      end;
    WRITELN;
    WRITE('                  Press the <ENTER> key.  ');
    READLN(Ans);
    WRITELN;
  end;

begin                                            {Begin Main Program}
  Meth := 1;
  FunType := 1;
  A := 0;
  B := 1;
  Y0 := 0;
  M := 1;
  State := Working;
  while Meth <> 0 do
    begin
      MESSAGE(Meth);
      DoMo := Go;
      while DoMo = Go do
        begin
          INPUT(FunType, Meth);
          while (State = Working) or (State = Changes) do
            begin
              EPOINTS(A, B, H, N, M, State);
              case Meth of
                1: 
                  Dirichlet(A, B, H, N, M, U);
                2: 
                  Writeln('case two');
              end;
              RESULTS(FunType, U, N, M);
              WRITELN;
              WRITELN;
              WRITE('     Want to use a  different  initial condition ?  <Y/N>  ');
              READLN(Ans);
              WRITELN;
              if (Ans <> 'Y') and (Ans <> 'y') then
                State := Done
              else
                State := Changes;
            end;
          WRITELN;
          WRITE('     Want to  change  the  differential equation ?  <Y/N>  ');
          READLN(Ans);
          if (Ans <> 'Y') and (Ans <> 'y') then
            DoMo := Stop
          else
            State := Changes;
        end;
      Mess := 'Want to try another method of approximation ?  <Y/N>  ';
      Ans := 'N';
      if (Ans <> 'Y') and (Ans <> 'y') then
        Meth := 0
      else
        State := Changes;
    end;
end.                                            {End of Main Program}

